<?php

namespace app\models\active;

use Yii;
use yii\db\ActiveRecord;
use app\models\User;
use app\models\active\Business;

class Mybusiness extends ActiveRecord
{

		public static function AutoUp()
		{
			
			$user = User :: findOne(Yii::$app->user->id);
			
			$mybusiness = static :: find()->where(['user' => $user->id])->andWhere(['<','level','10000'])->orderBy('business DESC')->all();
			
			foreach($mybusiness as $mbs):
			
			
			$business = Business :: findOne($mbs['business']);
			
			$price = $mbs['price_default'];
			
			$level = $mbs['level'];
			
			$income = $mbs['income'];
			
			while($user->money > ($price*$level) && $level < 10000){
				
				$user->money = $user->money - $price*$level;
				
				$level++;
				
				$income = $income+$mbs['income_default'];
				
				
			}

            if ($level >= 10000) {
                if (User:: Achievements($user->id, 11) < 10) {
                    User:: AchievementsSet($user->id, 11, User:: Achievements($user->id, 11) + 1);
                }
            }

			$mybsn = static :: findOne($mbs['id']);
			$mybsn->level = $level;
			$mybsn->income = $income;
			$mybsn->save();
			
			$user->save();
			

			endforeach;
			
		}
		
	public static function MaxUp($business_id)
	{
			
			$user = User :: findOne(Yii::$app->user->id);
			
			$business = static :: findOne(['user' => $user->id, 'id' => $business_id]);
			
			
			$price = $business->price_default;
			
			$level = $business->level;
			
			$income = $business->income;
			
			while($user->money > ($price*$level) && $level < 10000){
				
				$user->money = $user->money - $price*$level;
				
				$level++;
				
				$income = $income+$business->income_default;
				
				
			}
			if ($level >= 10000) {
                if (User:: Achievements($user->id, 11) < 10) {
                    User:: AchievementsSet($user->id, 11, User:: Achievements($user->id, 11) + 1);
                }
            }
			$business->level = $level > 10000 ? 10000 : $level;
			$business->income = $income;
			$business->save();
			
			$user->save();
			
			
	}
		
	public static function Price($id = null, $var = 1)
	{
		
		$business = static :: findOne($id);
		
		$bsn = Business :: findOne($business->business);
		
		$price = 0;
		
		$k = 0;
		
		while($k < $var){
			
			$price = $price+$business->price_default*$business->level;
			$k++;
		}
		
		return $price;
		
	}
	
}